/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;

import java.net.URLConnection;
import java.net.URL;

import java.util.Date;
import java.util.List;

public class RSSFeed {

    //private URL url ;
    private URLConnection url;
    private SyndFeedInput input;
    private SyndFeed feed ;
    private String errorMessage;

    /**
     * Static value for OK
     */
    public static int RSS_OK=1;
    /**
     * static value for problems
     */
    public static int RSS_ERR=0;
    
    public RSSFeed(){
        input = new SyndFeedInput();
        input.setXmlHealerOn(true);
        errorMessage = "Not Initialized";
    }
    /**
     * 
     * @param theURL
     * @return RSSFeed.RSS_OK if the feed was correctly downloaded from the URL
     * @return RSSFeed.RSS_ERR if the feed is not initialized or there are problems with the download
     */
    public int InitRSS(String theURL){
        if (!theURL.equals("")){
            try {
                    //url = new URL(theURL);
                    url = new URL(theURL).openConnection();
                    //
                    url.setRequestProperty("User-Agent", "IPRI");
                    //
                    XmlReader reader = new XmlReader(url);
                    feed = input.build(reader);
                    errorMessage = "";
                    return RSS_OK;
            }
            catch (Exception ex) {
                //ex.printStackTrace();
                errorMessage = ex.getMessage();
                 //debug
                //System.out.println(String.format("Feed build problem : %s'", errorMessage ));
                return RSS_ERR;
            }
        }
        else{
            
            return RSS_ERR;
        }
    }
   public int GetFeedItemCount()
    {
        if (errorMessage.equals("")) {
            return feed.getEntries().size();
        }
        else {
            return RSS_ERR;
        }
        
    }
    
    public Date GetPubDate()
    {
        if (errorMessage.equals("")) {
            return feed.getPublishedDate();
        }
        else {
            return null;
        }
        
    }
    
    public SyndEntryImpl[] GetEntries(){
        if (errorMessage.equals("")) {
            List<SyndEntryImpl> entries = feed.getEntries();
            SyndEntryImpl[] result = new SyndEntryImpl[entries.size()];
            entries.toArray(result);
            return result;
        }
        else {
            return null;
        }
    }
    
    public String GetRSSFeed(){
        
        if (errorMessage.equals("")) {
            return feed.toString();
        }
        else {
            return errorMessage;
        }
    }

    public String getEncoding(){
        if (errorMessage.equals("")) {
            return feed.getEncoding();
        }
        else {
            return errorMessage;
        }
    }
    
    public String GetErrorMsg() {
        return errorMessage;
    }
}
